<?php

namespace App\Http\Controllers;
use App\Models\ModemInfo;
use App\Models\DevicePort;

use Illuminate\Http\Request;
use Symfony\Component\Console\Descriptor\Descriptor;

class DashboardController extends Controller
{
   



public function index() {
    $data = ModemInfo::all();
    return view('Dashboard', ['data' => $data]);

}

public function show($id)
{
    $modem = ModemInfo::with('devicePorts')->findOrFail($id);
    $data = $modem->devicePorts;

    return view('equipment_detail', compact('data', 'modem'));
}


public function jsonData($id)
{
    $modem = ModemInfo::with('devicePorts')->findOrFail($id);
    return response()->json($modem->devicePorts);
}
}