<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DevicePort extends Model
{
    // Table name (optional if pluralization is default)
    protected $table = 'device_ports';

    // Mass assignable attributes
    protected $fillable = [
        'modem_info_id',
        'port_name',
        'modem_model',
        'functionality',
        'sim_iccid',
        'subscriber_imsi',
        'imei',
        'signal_quality',
        'sim_pin_status',
        'network_operator',
        'timer_seconds',
        'last_update',
        'operator_errors',
    ];

    // Cast attributes to native types
    protected $casts = [
        'sim_pin_status' => 'boolean',
        'last_update' => 'datetime',
    ];

    /**
     * Get the modem info (parent) for this device port.
     */
    public function modemInfo()
    {
        return $this->belongsTo(ModemInfo::class, 'modem_info_id');
    }
}
