<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ModemInfo extends Model
{
    use HasFactory;

      // Table name (optional if plural is different)
    protected $table = 'modem_info';

    // Mass assignable attributes
    protected $fillable = [
        'api_key',
        'equipment_uuid',
        'number_of_ports',
        'partner_contact',
        'country',
    ];

    // Relationships

    /**
     * Get the device ports associated with this modem info.
     */
    public function devicePorts()
    {
        return $this->hasMany(DevicePort::class, 'modem_info_id');
    }
}
