<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
 public function up()
    {
        Schema::create('modem_info', function (Blueprint $table) {
            $table->id();
            $table->string('api_key', 50);
            $table->string('equipment_uuid', 100)->unique();
            $table->integer('number_of_ports')->default(0);
            $table->string('partner_contact')->nullable();
            $table->string('country', 100)->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('modem_info');
    }
};
