<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDevicePortsTable extends Migration
{
public function up()
    {
        Schema::create('device_ports', function (Blueprint $table) {
            $table->id();
            $table->foreignId('modem_info_id')->constrained('modem_info')->onDelete('cascade');
            $table->string('port_name', 20)->nullable();
            $table->string('modem_model', 100)->nullable();
            $table->integer('functionality')->nullable();
            $table->string('sim_iccid', 50)->nullable();
            $table->string('subscriber_imsi', 50)->nullable();
            $table->string('imei', 50)->nullable();
            $table->string('signal_quality')->nullable(); // could be JSON string
            $table->boolean('sim_pin_status')->nullable();
            $table->string('network_operator', 100)->nullable();
            $table->integer('timer_seconds')->nullable();
            $table->timestamp('last_update')->nullable();
            $table->integer('operator_errors')->nullable();
            $table->timestamps();

            $table->index(['modem_info_id', 'port_name']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('device_ports');
    }
}
