

<?php $__env->startSection('content'); ?>

<?php if (! $__env->hasRenderedOnce('ea542bf4-ec7c-44da-9c31-212dad834ef9')): $__env->markAsRenderedOnce('ea542bf4-ec7c-44da-9c31-212dad834ef9'); ?>
<style>
/* ... your existing CSS for signal bars ... */
.signal-bars {
    display: inline-flex;
    align-items: flex-end;
    gap: 2px;
    height: 20px;
    margin-right: 8px;
}
.signal-bar {
    width: 4px;
    border-radius: 1px;
    transition: all 0.3s ease;
}
.signal-bar.bar-1 { height: 4px; }
.signal-bar.bar-2 { height: 8px; }
.signal-bar.bar-3 { height: 12px; }
.signal-bar.bar-4 { height: 16px; }
.signal-bar.bar-5 { height: 20px; }

.signal-bar.active.excellent { background-color: #22c55e; }
.signal-bar.active.good { background-color: #84cc16; }
.signal-bar.active.fair { background-color: #eab308; }
.signal-bar.active.poor { background-color: #f97316; }
.signal-bar.active.very-poor { background-color: #ef4444; }
.signal-bar.inactive { background-color: #e5e7eb; }

.signal-container {
    display: flex;
    align-items: center;
    gap: 8px;
}

.signal-value {
    font-size: 0.75rem;
    color: #6b7280;
    font-weight: 500;
}

.no-signal {
    color: #9ca3af;
    font-style: italic;
    font-size: 0.875rem;
}
.raw-json-container {
    margin-top: 20px;
    background: #f4f4f4;
    padding: 10px;
    border-radius: 6px;
    max-height: 300px;
    overflow-y: auto;
    font-size: 0.8rem;
    white-space: pre-wrap;
    user-select: text;
}
.toggle-json-btn {
    cursor: pointer;
    margin-bottom: 10px;
}
</style>
<?php endif; ?>

<?php
$getSignalInfo = function($signal) {
    if ($signal == 0 || $signal == 99) {
        return ['bars' => 0, 'quality' => 'none'];
    }
    if ($signal >= 25) return ['bars' => 5, 'quality' => 'excellent'];
    if ($signal >= 19) return ['bars' => 4, 'quality' => 'good'];
    if ($signal >= 13) return ['bars' => 3, 'quality' => 'fair'];
    if ($signal >= 7)  return ['bars' => 2, 'quality' => 'poor'];
    if ($signal >= 1)  return ['bars' => 1, 'quality' => 'very-poor'];
    return ['bars' => 0, 'quality' => 'none'];
};
?>

<div class="container-fluid px-4 py-3">
    <!-- header and tabs same as before -->

    <div class="table-responsive">
        <table class="table table-bordered table-hover">
            <thead class="table-light">
                <tr>
                    <th>Position</th>
                    <th>USB (port_name)</th>
                    <th>CCID (sim_iccid)</th>
                    <th>IMSI (subscriber_imsi)</th>
                    <th>SIM Country</th>
                    <th>SIM Operator (network_operator)</th>
                    <th>PIN (sim_pin_status)</th>
                    <th>Sim Network Signal</th>
                    <th>Operator</th>
                    <th>Phone</th>
                    <th>FS</th>
                    <th>Online</th>
                    <th>Ordered</th>
                    <th>USD</th>
                    <th>ERROR (operator_errors)</th>
                </tr>
            </thead>
            <tbody id="device-table-body">
                
                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $device): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $signalArray = json_decode($device->signal_quality, true);
                        $signalsInt = is_array($signalArray) 
                            ? array_filter(array_map('intval', $signalArray), fn($val) => $val > 0) 
                            : [];
                        sort($signalsInt);
                    ?>
                    <tr class="<?php echo e($device->operator_errors ? 'table-danger' : 'table-primary'); ?>">
                        <td><?php echo e($index + 1); ?></td>
                        <td><?php echo e($device->port_name ?? 'N/A'); ?></td>
                        <td><?php echo e($device->sim_iccid ?? '0'); ?></td>
                        <td><?php echo e($device->subscriber_imsi ?? '0'); ?></td>
                        <td>unknown</td>
                        <td><?php echo e($device->network_operator ?? ''); ?></td>
                        <td><?php echo e($device->sim_pin_status == 1 ? 'OK' : 'ERROR'); ?></td>
                        <td>
                            <?php if(empty($signalsInt)): ?>
                                <span class="no-signal">No signal data</span>
                            <?php else: ?>
                                <div class="d-flex flex-wrap gap-3">
                                    <?php $__currentLoopData = $signalsInt; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $signal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $signalInfo = $getSignalInfo($signal);
                                        ?>
                                        <div class="signal-container">
                                            <div class="signal-bars">
                                                <?php for($i = 1; $i <= 5; $i++): ?>
                                                    <div class="signal-bar bar-<?php echo e($i); ?> <?php echo e($i <= $signalInfo['bars'] ? 'active ' . $signalInfo['quality'] : 'inactive'); ?>"></div>
                                                <?php endfor; ?>
                                            </div>
                                            <span class="signal-value">(<?php echo e($signal); ?>)</span>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($device->modem_model ?? 'Searching.. (auto)'); ?></td>
                        <td></td>
                        <td></td>
                        <td><?php echo e($device->last_update ? 'ON' : 'OFF'); ?></td>
                        <td></td>
                        <td>0$</td>
                        <td><?php echo e($device->operator_errors ? 'Error' : 'Modem offline'); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <div class="mt-2 mb-4">
        <p>Showing 1 to <?php echo e($data->count()); ?> of <?php echo e($data->count()); ?> entries</p>
    </div>

    <button class="btn btn-sm btn-outline-primary toggle-json-btn" onclick="toggleRawJson()">Toggle Raw JSON Data</button>
    <pre id="raw-json" class="raw-json-container" style="display:none;"></pre>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const $tbody = document.getElementById('device-table-body');
    const $rawJson = document.getElementById('raw-json');
    const infoParagraph = document.querySelector('.mt-2.mb-4 p');

    function getSignalInfo(signal) {
        signal = Number(signal);
        if (signal === 0 || signal === 99) return { bars: 0, quality: 'none' };
        if (signal >= 25) return { bars: 5, quality: 'excellent' };
        if (signal >= 19) return { bars: 4, quality: 'good' };
        if (signal >= 13) return { bars: 3, quality: 'fair' };
        if (signal >= 7) return { bars: 2, quality: 'poor' };
        if (signal >= 1) return { bars: 1, quality: 'very-poor' };
        return { bars: 0, quality: 'none' };
    }

    function createSignalBars(signal) {
        const { bars, quality } = getSignalInfo(signal);
        let barsHtml = '';
        for (let i = 1; i <= 5; i++) {
            barsHtml += `<div class="signal-bar bar-${i} ${i <= bars ? 'active ' + quality : 'inactive'}"></div>`;
        }
        return barsHtml;
    }

    function buildRow(device, index) {
        let signalsRaw = [];
        try {
            signalsRaw = device.signal_quality ? JSON.parse(device.signal_quality) : [];
        } catch (e) {
            console.error("Invalid JSON in signal_quality for device", device, e);
        }

        console.log('signalsRaw for device index', index, signalsRaw);

        const signalsInt = signalsRaw.filter(s => s > 0).sort((a,b) => a - b);

        let signalHtml = '';
        if (signalsInt.length === 0) {
            signalHtml = '<span class="no-signal">No signal data</span>';
        } else {
            signalHtml = signalsInt.map(signal => `
                <div class="signal-container">
                    <div class="signal-bars">${createSignalBars(signal)}</div>
                    <span class="signal-value">(${signal})</span>
                </div>
            `).join('');
        }

        return `
            <tr class="${device.operator_errors ? 'table-danger' : 'table-primary'}">
                <td>${index + 1}</td>
                <td>${device.port_name ?? 'N/A'}</td>
                <td>${device.sim_iccid ?? '0'}</td>
                <td>${device.subscriber_imsi ?? '0'}</td>
                <td>unknown</td>
                <td>${device.network_operator ?? ''}</td>
                <td>${device.sim_pin_status == 1 ? 'OK' : 'ERROR'}</td>
                <td><div class="d-flex flex-wrap gap-3">${signalHtml}</div></td>
                <td>${device.modem_model ?? 'Searching.. (auto)'}</td>
                <td></td>
                <td></td>
                <td>${device.last_update ? 'ON' : 'OFF'}</td>
                <td></td>
                <td>0$</td>
                <td>${device.operator_errors ? 'Error' : 'Modem offline'}</td>
            </tr>
        `;
    }

    async function fetchDataAndUpdate() {
        try {
            const response = await fetch('/devices-json');
            if (!response.ok) throw new Error('Network response was not ok');
            const devices = await response.json();

            console.log('Fetched devices:', devices);

            const rowsHtml = devices.map((device, idx) => buildRow(device, idx)).join('');
            $tbody.innerHTML = rowsHtml;

            $rawJson.textContent = JSON.stringify(devices, null, 2);

            if (infoParagraph) {
                infoParagraph.textContent = `Showing 1 to ${devices.length} of ${devices.length} entries`;
            }
        } catch (err) {
            console.error('Failed to fetch devices data:', err);
        }
    }

    // Initial fetch
    fetchDataAndUpdate();

    // Refresh every 10 seconds
    setInterval(fetchDataAndUpdate, 10000);

    // Toggle raw JSON visibility
    window.toggleRawJson = function() {
        if ($rawJson.style.display === 'none') {
            $rawJson.style.display = 'block';
        } else {
            $rawJson.style.display = 'none';
        }
    };

});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\zedsmsapi\api\resources\views/Device.blade.php ENDPATH**/ ?>